<?php

namespace App\Modes\Patient;

use Illuminate\Database\Eloquent\Model;

class PAtient extends Model 
{

    protected $table = 'patients';
    public $timestamps = true;

    public function insurance()
    {
        return $this->hasMany('PatientInsurance', 'patient_id');
    }

    public function cases()
    {
        return $this->hasMany('Case', 'patient_id');
    }

    public function logs()
    {
        return $this->hasMany('UserLog', 'patient_id');
    }

    public function contacts()
    {
        return $this->hasMany('PatientContacts', 'patient_id');
    }

    public function tags()
    {
        return $this->hasMany('Tags', 'commentable_id');
    }

    public function notes()
    {
        return $this->hasMany('Notes', 'commentable_id');
    }

}